/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.server.IPECommands;
import filenet.vw.server.WorkBasketRef;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public final class VWRoleDefinition
extends VWMLABase
implements Serializable,
Cloneable,
IVWtoXML {
    private static final long serialVersionUID = 7462L;
    protected transient VWApplicationSpaceDefinition m_myAppSpaceDef = null;
    protected String m_name = null;
    protected String m_description = null;
    protected String m_homePageURL = null;
    private VWParticipant[] m_roleParticipants = null;
    private String[] m_roleParticipantsNames = null;
    private boolean m_hasRoleParticipantsChanged = false;
    private VWWorkBasketDefinition[] m_workBasketDefs = new VWWorkBasketDefinition[0];
    private WorkBasketRef[] m_ORBWorkBaskets = null;
    private int m_nObjId = 0;
    protected int m_nRevision = 0;
    protected Hashtable m_attributes = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:21:56 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/3 $";
    }

    protected VWRoleDefinition(int nRevision, String name, VWApplicationSpaceDefinition theAppSpaceDef) throws VWException {
        this.m_nRevision = nRevision;
        if (theAppSpaceDef == null) {
            throw new VWException("vw.api.VWApplicationSpaceDefErr", "The application space definition object can not be null");
        }
        if (name == null || name.trim().length() == 0) {
            throw new VWException("vw.api.VWRoleDefNameErr", "The role definition name can not be null or empty");
        }
        this.setMyApplicationSpaceDefinition(theAppSpaceDef);
        this.setName(name);
    }

    protected void setMyApplicationSpaceDefinition(VWApplicationSpaceDefinition appSpaceDef) throws VWException {
        this.m_myAppSpaceDef = appSpaceDef;
        if (appSpaceDef != null) {
            super.setSession(appSpaceDef.getSession());
        }
    }

    public int getRevision() throws VWException {
        return this.m_nRevision;
    }

    public String getName() throws VWException {
        return this.translateStr(this.m_name);
    }

    public String getAuthoredName() throws VWException {
        return this.translateToAuthored(this.m_name);
    }

    public void setName(String theName) throws VWException {
        if (theName != null) {
            theName = theName.trim();
        }
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWRoleDefinitionInvalidName", "The role name is invalid, (null or zero length).");
        }
        if (theName.equals(this.m_name)) {
            return;
        }
        if (theName.length() > 128) {
            throw new VWException("vw.api.VWRoleDefinitionNameTooLong", "The role name can not exceed 128 characters).");
        }
        if (theName.startsWith("~")) {
            throw new VWException("vw.api.VWRoleDefinitionName.InvalidSartChar", "The role name can not start with ''~''.");
        }
        if (this.m_myAppSpaceDef.getRoleDefinition(theName) != null) {
            throw new VWException("vw.api.VWRoleDefinition.roleAlreadyExists", "A role definition with that name already exists.");
        }
        this.m_name = theName;
        this.setHasChanged(true);
    }

    public String getDescription() throws VWException {
        if (this.m_description != null) {
            return super.translateStr(this.m_description);
        }
        return null;
    }

    public void setDescription(String description) throws VWException {
        this.m_description = description;
        this.setHasChanged(true);
    }

    public String getHomePageURL() throws VWException {
        return this.m_homePageURL;
    }

    public void setHomePageURL(String homePageURL) throws VWException {
        this.m_homePageURL = homePageURL;
        this.setHasChanged(true);
    }

    public VWParticipant[] fetchRoleParticipants() throws VWException {
        if (this.m_roleParticipants == null) {
            if (this.m_roleParticipantsNames != null) {
                VWSession session;
                if (this.m_roleParticipantsNames.length > 0 && (session = this.getSession()) != null) {
                    this.m_roleParticipants = session.fetchParticipantsPx(null, this.m_roleParticipantsNames);
                }
                if (this.m_roleParticipants != null) {
                    this.m_roleParticipantsNames = null;
                }
            } else {
                VWParticipantList list;
                IPECommands cmdSession = this.m_myAppSpaceDef.getCmdSession();
                if (cmdSession != null && this.m_nObjId > 0 && (list = cmdSession.fetchRoleParticipants(this.m_name, this.m_myAppSpaceDef.m_name)) != null) {
                    int count = list.fetchCount;
                    this.m_roleParticipants = new VWParticipant[count];
                    for (int i = 0; i < count; ++i) {
                        this.m_roleParticipants[i] = (VWParticipant)list.next();
                    }
                }
            }
        }
        return this.m_roleParticipants;
    }

    public boolean hasRoleParticipantsChanged() throws VWException {
        return this.m_hasRoleParticipantsChanged;
    }

    public void setRoleParticipants(VWParticipant[] members) throws VWException {
        if (members == null) {
            members = new VWParticipant[]{};
        }
        this.m_roleParticipantsNames = null;
        this.m_roleParticipants = members;
        this.m_hasRoleParticipantsChanged = true;
        this.setHasChanged(true);
    }

    public String[] getRoleParticipantNames() throws VWException {
        if (this.m_roleParticipantsNames != null) {
            return (String[])this.m_roleParticipantsNames.clone();
        }
        this.fetchRoleParticipants();
        return this.getRoleParticipantNames(this.m_roleParticipants);
    }

    protected void setRoleParticipantByNames(String[] participants) throws VWException {
        this.m_roleParticipantsNames = participants != null ? participants : new String[0];
        this.m_roleParticipants = null;
        this.m_hasRoleParticipantsChanged = true;
        this.setHasChanged(true);
    }

    public VWWorkBasketDefinition[] getWorkBasketDefinitions() throws VWException {
        return this.m_workBasketDefs;
    }

    public void setWorkBasketDefinitions(VWWorkBasketDefinition[] workBasketDefs) throws VWException {
        this.m_workBasketDefs = workBasketDefs;
        this.setHasChanged(true);
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.m_attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        Hashtable theAttributes;
        this.m_attributes = theAttributeInfo != null ? (theAttributes = theAttributeInfo.attributes) : null;
        this.setHasChanged(true);
    }

    public int getObjId() throws VWException {
        return this.m_nObjId;
    }

    public String toString() {
        return this.m_name;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    public Object clone() {
        VWRoleDefinition roleDef = null;
        try {
            roleDef = (VWRoleDefinition)super.clone();
            roleDef.setWorkBasketDefinitions((VWWorkBasketDefinition[])this.m_workBasketDefs.clone());
            if (this.m_attributes != null) {
                roleDef.m_attributes = (Hashtable)this.m_attributes.clone();
            }
            if (this.m_roleParticipants != null) {
                roleDef.m_roleParticipants = (VWParticipant[])this.m_roleParticipants.clone();
            }
            if (this.m_roleParticipantsNames != null) {
                roleDef.m_roleParticipantsNames = (String[])this.m_roleParticipantsNames.clone();
            }
            return roleDef;
        }
        catch (CloneNotSupportedException cnsEx) {
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return roleDef;
    }

    protected void setObjId(int theNewObjId) throws VWException {
        if (theNewObjId < 0) {
            throw new VWException("vw.api.VWRoleDefObjIdErr", "The object id can not be a negative value.");
        }
        this.m_nObjId = theNewObjId;
        this.setHasChanged(true);
    }

    protected void setRevision(int theRevision) throws VWException {
        if (theRevision < 0) {
            throw new VWException("vw.api.VWRoleDefRevisionErr", "The revision can not be a negative value.");
        }
        this.m_nRevision = theRevision;
        this.setHasChanged(true);
    }

    protected void setHasChanged(boolean theNewValue) {
        if (this.m_myAppSpaceDef != null) {
            this.m_myAppSpaceDef.setHasChanged(theNewValue);
        }
    }

    protected String[] getRoleParticipantNames(VWParticipant[] roleParticipants) throws VWException {
        int numParticipants;
        int n = numParticipants = roleParticipants == null ? 0 : roleParticipants.length;
        if (numParticipants == 0) {
            return null;
        }
        Vector<String> roleVector = new Vector<String>(numParticipants);
        for (int i = 0; i < numParticipants; ++i) {
            if (roleParticipants[i] == null) continue;
            roleVector.add(roleParticipants[i].getParticipantName());
        }
        return roleVector.toArray(new String[0]);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        int i;
        if (theBuffer == null) {
            throw new VWException("vw.api.VWRoleDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        String INDENT_3 = INDENT_2 + "\t";
        theBuffer.append(INDENT_0 + "<" + "RoleDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.m_name) + "\"\n");
        theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.m_description) + "\"\n");
        if (this.m_homePageURL != null) {
            theBuffer.append(INDENT_1 + "HomePageURL" + "=\"" + this.m_homePageURL + "\"\n");
        }
        theBuffer.append(INDENT_1 + "Revision" + "=\"" + this.getRevision() + "\"\n");
        theBuffer.append(INDENT_1 + "ObjectId" + "=\"" + this.getObjId() + "\"");
        theBuffer.append(">\n");
        this.fetchRoleParticipants();
        theBuffer.append(INDENT_1 + "<" + "RoleParticipants" + ">\n");
        String[] roleParticipantNames = this.getRoleParticipantNames();
        if (roleParticipantNames != null && roleParticipantNames.length > 0) {
            for (i = 0; i < roleParticipantNames.length; ++i) {
                if (roleParticipantNames[i] == null) continue;
                theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(roleParticipantNames[i]) + "</" + "Value" + ">\n");
            }
        }
        theBuffer.append(INDENT_1 + "</" + "RoleParticipants" + ">\n");
        if (this.m_workBasketDefs != null && this.m_workBasketDefs.length > 0) {
            theBuffer.append(INDENT_1 + "<" + "InBaskets" + ">\n");
            if (this.m_workBasketDefs != null && this.m_workBasketDefs.length > 0) {
                for (i = 0; i < this.m_workBasketDefs.length; ++i) {
                    if (this.m_workBasketDefs[i] == null) continue;
                    theBuffer.append(INDENT_2 + "<" + "InBasket" + "\n");
                    theBuffer.append(INDENT_3 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.m_workBasketDefs[i].getName()) + "\"\n");
                    theBuffer.append(INDENT_3 + "QueueName" + "=\"" + VWXMLHandler.toXMLString(this.m_workBasketDefs[i].m_myQueueDef.getName()) + "\"");
                    theBuffer.append(">\n");
                    theBuffer.append(INDENT_2 + "</" + "InBasket" + ">\n");
                }
            }
            theBuffer.append(INDENT_1 + "</" + "InBaskets" + ">\n");
        }
        VWAttributeInfo theAttributeInfo = this.getAttributeInfo();
        theAttributeInfo.toXML(theBuffer, INDENT_1);
        theBuffer.append(INDENT_0 + "</" + "RoleDefinition" + ">\n");
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.m_attributes = theAttributes;
    }

    protected void removeReferences() {
        int i;
        if (this.m_attributes != null) {
            this.m_attributes.clear();
        }
        this.m_attributes = null;
        this.m_description = null;
        this.m_homePageURL = null;
        this.m_myAppSpaceDef = null;
        this.m_name = null;
        if (this.m_roleParticipants != null) {
            for (i = 0; i < this.m_roleParticipants.length; ++i) {
                this.m_roleParticipants[i] = null;
            }
            this.m_roleParticipants = null;
        }
        if (this.m_workBasketDefs != null) {
            for (i = 0; i < this.m_workBasketDefs.length; ++i) {
                this.m_workBasketDefs[i] = null;
            }
            this.m_workBasketDefs = null;
        }
    }

    protected void setORBWorkBaskets(WorkBasketRef[] orbWorkBaskets) {
        this.m_ORBWorkBaskets = orbWorkBaskets;
    }

    protected void initWorkBasketDefsFromOrb(VWSystemConfiguration sysConfig) {
        if (this.m_ORBWorkBaskets != null && this.m_ORBWorkBaskets.length > 0 && sysConfig != null) {
            String queueName = null;
            String wbName = null;
            Vector<VWWorkBasketDefinition> workBasketDefs = new Vector<VWWorkBasketDefinition>();
            WorkBasketRef[] orbWorkBaskets = this.m_ORBWorkBaskets;
            this.m_ORBWorkBaskets = null;
            for (int i = 0; i < orbWorkBaskets.length; ++i) {
                if (orbWorkBaskets[i] == null) continue;
                queueName = orbWorkBaskets[i].queueName;
                wbName = orbWorkBaskets[i].workBasketName;
                if (queueName == null || wbName == null) continue;
                queueName = queueName.trim();
                wbName = wbName.trim();
                if (queueName.length() <= 0 || wbName.length() <= 0) continue;
                try {
                    VWQueueDefinition queueDef = sysConfig.getQueueDefinition(queueName);
                    if (queueDef == null) continue;
                    VWWorkBasketDefinition wbDef = null;
                    try {
                        wbDef = queueDef.getWorkBasketDefinition(wbName);
                    }
                    catch (VWException ex) {
                        wbDef = queueDef.createWorkBasketDefinition(wbName);
                    }
                    if (wbDef == null) continue;
                    workBasketDefs.add(wbDef);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (workBasketDefs != null && workBasketDefs.size() > 0) {
                this.m_workBasketDefs = new VWWorkBasketDefinition[workBasketDefs.size()];
                workBasketDefs.toArray(this.m_workBasketDefs);
            }
        }
    }

    protected void reset() {
        this.m_description = null;
        this.m_homePageURL = null;
        this.m_roleParticipants = new VWParticipant[0];
        this.m_roleParticipantsNames = null;
        this.m_workBasketDefs = new VWWorkBasketDefinition[0];
        this.m_ORBWorkBaskets = null;
        this.m_nObjId = 0;
        this.m_nRevision = 0;
        this.m_attributes = null;
        this.setHasChanged(true);
    }
}

